<?php // Copyright (c) 2016, SWITCH ?>
<!DOCTYPE html>
<html class="no-js">
<head>
	<title><?php echo getLocalString('title') ?></title> 
	<meta http-equiv="content-type" content="text/html; charset=utf-8">
	<meta name="keywords" content="Home Organisation, Discovery Service, WAYF, Shibboleth, Login, AAI">
	<meta name="description" content="Choose your home organisation to authenticate">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=yes">
	<link rel="stylesheet" href="<?php echo $cssURL ?>/styles.css" type="text/css">
	<link rel="stylesheet" href="<?php echo $_SERVER['SCRIPT_NAME'] ?>/ImprovedDropDown.css" type="text/css">
	<!-- HTML5 shim, for IE6-8 support of HTML5 elements -->
		    <!--[if lt IE 9]>
		      <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
		    <![endif]-->
	<link rel="shortcut icon" type="image/png" href="<?php echo $imageURL ?>/page_icon.png" />
	<script type="text/javascript" src="<?php echo $javascriptURL ?>/jquery-1.8.2.js"></script>
	<script type="text/javascript" src="<?php echo $javascriptURL ?>/bootstrap.js"></script>
	<script type="text/javascript" src="<?php echo $javascriptURL ?>/improvedDropDown.js"></script>
	<script type="text/javascript" src="<?php echo $javascriptURL ?>/permanentSubmit.js"></script>
	<script type="text/javascript">
	<!--
	
	// Prevent that WAYF is loaded in an IFRAME
	function preventIframeEmbedding(){
		if (top != self) {
			top.location = self.location;
		}
	}
	var isChrome = /Chrome/.test(navigator.userAgent) && /Google Inc/.test(navigator.vendor);	
	// Set focus to submit button or drop down list
	function setFocus(){
		// Skip this if we cannot access the form elements
		if(!isChrome)
			return; //maybe https://jira.daasi.de/browse/DARIAH3-953
		if (
			!document.IdPList || 
			!document.IdPList.Select
			){
			return;
		}
		
		if (
				document.IdPList.user_idp && 
				document.IdPList.user_idp.selectedIndex == 0
			){
			// Set focus to select
			document.IdPList.user_idp.focus({preventDefault: true, preventScroll: true});
		} else {
			// Set focus to submit button
			document.IdPList.Select.focus({preventDefault: true, preventScroll: true});
		}


	}
	
	// Perform input validation on WAYF form
	function checkForm(){
		if(
			document.IdPList.user_idp && 
			document.IdPList.user_idp.selectedIndex == 0
		){
			alert(unescape('<?php echo getLocalString('make_selection', 'js') ?>'));
			return false;
		} else {
			return true;
		}
	}
	
	// Init WAYF
	function init(){
		preventIframeEmbedding();
		
		setFocus();
		
		if (<?php echo ($useImprovedDropDownList) ? 'true' : 'false' ?>){
			
			var searchText = '<?php echo getLocalString('search_idp', 'js') ?>';
			$("#userIdPSelection:enabled option[value='-']").text(searchText);
			
			// Convert select element into improved drop down list
			$("#userIdPSelection:enabled").improveDropDown({
				iconPath:'<?php echo $imageURL ?>/drop_icon.png',
				noMatchesText: '<?php echo getLocalString('no_idp_found', 'js') ?>',
				noItemsText: '<?php echo getLocalString('no_idp_available', 'js') ?>',
				disableRemoteLogos: <?php echo ($disableRemoteLogos) ? 'true' : 'false' ?>
			});
		}
	}
	
	// Call init function when DOM is ready
	$(document).ready(init);
	
	-->
	</script>
</head>

<body class="site -no-header">
	<div class="site_wrap">
	   <div class="logo">
			<a class="logo_link -aai" href="https://de.dariah.eu/en/aai" target="_blank" title="Startseite">
				<img class="logo_logo -aai" src="images/dariah-aai-logo.svg" alt="DARIAH Authentication Authorisation Infrastructure">
				<svg class="logo_logo -aai -spike" xmlns="http://www.w3.org/2000/svg" width="792.966" height="184" viewBox="0 0 792.966 184">
					<path d="M503.056 78.332l-78.76-57.22-78.759 57.22 30.084 92.59h97.352z"></path>
				</svg>
			</a>
		</div>
				







